/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.io.File;
import java.io.FilenameFilter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.sourceforge.dvb.projectx.xinput.XInputFile;

/**
 * 30.01.2005
 * 
 * @author Hans
 */
public class GAufnahmeLocal extends GAufnahmeAbstract {

    private RandomAccessFile cridFile;

    private File aCridDirectory;

    private File[][] flMpgDateien;

    private File[] aFmpgDirectories;

    GAufnahmeLocal(String inpCridFilename) {
        this.cridFilename = inpCridFilename;
        try {
            readAufnahme();
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
    }

    /**
     * 
     * @param inpCridFile
     * @return String
     */
    private String readSender(RandomAccessFile inpCridFile) {
        String tmpName = getSender();
        try {
            if (inpCridFile.getFilePointer() >= inpCridFile.length()) {
                return tmpName;
            }
            inpCridFile.skipBytes(14);
            int len = inpCridFile.readShort();
            if (len > 0) {
                if (len > 25) {
                    len = 25;
                }
                byte[] tmpBs = new byte[len];
                inpCridFile.read(tmpBs, 0, tmpBs.length);
                tmpName = new String(tmpBs);
                tmpName = tmpName.trim();
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpName;
    }
    
    /**
     * 
     */
    public void readAufnahme() {
        try {
            GConsole.setInfo(cridFilename);
            setAnzahlFMPGsErwartet(0);
            setAnzahlFMPGsVorhanden(0);
            setAnzahlMPGsErwartet(0);
            setAnzahlMPGsVorhanden(0);
            anzahlByte = 0;
            cridFile = new RandomAccessFile(cridFilename, "r");
            byte b[];
            // long size = cridFile.length();
            cridFile.skipBytes(12);

            // Status: vor, whrend oder nach der Aufnahme
            status = cridFile.readInt();
            // Startzeit der Sendung in Sekunden
            startZeitInSek = cridFile.readInt();
            // Endzeit der Sendung in Sekunden (seit dem 1.1.1970)
            endeZeitInSek = cridFile.readInt();
            //
            cridFile.skipBytes(16);
            // unique Serien-ID
            aSerienID = cridFile.readInt();
            // gesperrt zum Lschen ? (0: nein, 1: ja)
            gesperrt = cridFile.readShort();

            // Titel der Sendung
            b = new byte[cridFile.readInt()];
            cridFile.read(b, 0, b.length);
            titel = new String(b);
            titel = new DvbString(titel).getDisplayString();

            int z = cridFile.readInt();
            setAnzahlFMPGsErwartet(z);
            dateiNamenBasen = new String[z];
            for (int i = 0; i < z; i++) {
                // TODO: z > 1 bzw. i > 0 => Loecher in der Aufnahme ?
                b = new byte[cridFile.readInt()];
                cridFile.read(b, 0, b.length);
                // Dateinamen-Basis d.zugeh.mpg-Dateien
                dateiNamenBasen[i] = new String(b);
                // Aufnahmebeginn in Sekunden (seit dem 1.1.1970)
                aufnahmeBeginnInSek = cridFile.readInt();
                cridFile.skipBytes(16);
            } // for i

            b = new byte[cridFile.readInt()];
            cridFile.read(b, 0, b.length);
            // Genre/Herkunft/Zeit, z.B. "Spielfilm USA 2000"
            info = new String(b);
            info = new DvbString(info).getDisplayString();

            b = new byte[cridFile.readInt()];
            // Inhalt der Sendung
            cridFile.read(b, 0, b.length);
            inhalt = new String(b);
            inhalt = new DvbString(inhalt).getDisplayString();
            // Soviele Sekunden der Sendung wurden bereits gesehen
            gesehenBisInSek = cridFile.readInt();
            //
            // since FW 2.3.15 only
            setSender(readSender(cridFile));
            //
            cridFile.close();
            // } catch (Exception e) {
            // GConsole.setErrorMessage(e);
            // }
            // try {
            String tmpAufnahmeverzeichnis = new File(cridFilename).getParent();
            File tmpDirectory = new File(tmpAufnahmeverzeichnis);
            setCridDirectory(tmpDirectory);

            int anzb = (dateiNamenBasen == null) ? 0 : dateiNamenBasen.length;
            flMpgDateien = new File[anzb][];
            aFmpgDirectories = new File[anzb];
            setAnzahlFMPGsVorhanden(0);
            setAnzahlMPGsErwartet(0);
            setAnzahlMPGsVorhanden(0);
            for (int x = 0; x < anzb; x++) {
                String tmpRecordVerzeichnis = tmpAufnahmeverzeichnis;
                final String dateiNamenBasis = dateiNamenBasen[x];
                File tmpFile = new File(tmpRecordVerzeichnis, dateiNamenBasis);
                if (!tmpFile.exists()) { // neue .rec- Struktur?
                    if (!tmpRecordVerzeichnis.endsWith(File.separator)) {
                        tmpRecordVerzeichnis += File.separator;
                    }
                    tmpRecordVerzeichnis += ".rec" + File.separator;
                    tmpRecordVerzeichnis += dateiNamenBasis;
                    // nu aber ...
                    tmpDirectory = new File(tmpRecordVerzeichnis);
                }
                //
                setFmpgDirectory(x, tmpDirectory);
                //
                final List tmpList = readFmpgDateien(tmpDirectory,
                        dateiNamenBasis);
                aAnzahlMPGsErwartet += (tmpList == null) ? 0 : tmpList.size();
                //
                flMpgDateien[x] = tmpDirectory.listFiles(new FilenameFilter() {
                    public boolean accept(File f, String s) {
                        return (tmpList == null) ? false : tmpList.contains(s);
                    }
                });
                int anz = (flMpgDateien[x] == null) ? 0
                        : flMpgDateien[x].length;
                aAnzahlMPGsVorhanden += anz;
                if (anz > 1) { // Dateien (sicherheitshalber)sortieren
                    Arrays.sort(flMpgDateien[x]);
                }

                for (int i = 0; i < anz; i++) {
                    anzahlByte += flMpgDateien[x][i].length();
                } // for i
            } // for b
            setValid(true);
        } catch (Exception exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    /**
     * 
     * @param inpFile
     * @return List of Strings (filenames without path)
     */
    private List readFmpgDatei(File inpFile) {
        List tmpList = null;
        try {
            GConsole.setInfo(inpFile.toString());
            RandomAccessFile tmpRAF = new RandomAccessFile(inpFile, "r");
            long tmpSize = inpFile.length();
            long anz = tmpSize / 256;
            for (int i = 0; i < anz; i++) {
                tmpRAF.skipBytes(16);
                byte[] tmpBs = new byte[112];
                tmpRAF.read(tmpBs);
                String tmpFN = null;
                // terminierende Null suchen
                for (int x = 0; x < tmpBs.length; x++) {
                    if (tmpBs[x] == 0) {
                        String tmpStr = new String(tmpBs, 0, x);
                        String[] tmpStrs = tmpStr.split("/");
                        int len = (tmpStrs == null) ? 0 : tmpStrs.length;
                        if (len > 0) {
                            tmpFN = tmpStrs[len - 1];
                        } else {
                            tmpFN = tmpStr;
                        }
                        break;
                    }
                } // for x
                if (tmpFN != null) {
                    if (tmpList == null) {
                        tmpList = new ArrayList();
                    }
                    tmpList.add(tmpFN);
                }
                tmpRAF.skipBytes(128);
            } // for i

        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    /**
     * 
     * @param inpDir
     * @param inpDateinamenbasis
     * @return List of Strings (filenames without path)
     */
    private List readFmpgDateien(File inpDir, final String inpDateinamenbasis) {
        List tmpList = null;
        try {
            File[] tmpFiles = inpDir.listFiles(new FilenameFilter() {
                public boolean accept(File f, String s) {
                    return s.toLowerCase().equals(
                            inpDateinamenbasis.toLowerCase());
                }
            });
            int anzf = (tmpFiles == null) ? 0 : tmpFiles.length;
            aAnzahlFMPGsVorhanden += anzf;
            for (int i = 0; i < anzf; i++) {
                List tmpList2 = readFmpgDatei(tmpFiles[i]);
                if (tmpList2 != null) {
                    if (tmpList == null) {
                        tmpList = tmpList2;
                    } else {
                        tmpList.addAll(tmpList2);
                    }
                }
            } // for i
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getFlMpgDateien()
     */
    private Object[][] getFlMpgDateien() {
        return flMpgDateien;
    }

    public List getMpgFiles() {
        List tmpList = null;
        try {
            String[] tmpDateinamenBasen = getDateinamenBasen();
            int anzb = (tmpDateinamenBasen == null) ? 0
                    : tmpDateinamenBasen.length;
            for (int b = 0; b < anzb; b++) {
                File[] tmpFlMpgDateien = (File[]) getFlMpgDateien()[b];
                int anzf = (tmpFlMpgDateien == null) ? 0
                        : tmpFlMpgDateien.length;
                for (int i = 0; i < anzf; i++) {
                    File tmpFile = tmpFlMpgDateien[i];
                    XInputFile tmpXFile = new XInputFile(tmpFile);
                    if (tmpList == null) {
                        tmpList = new ArrayList();
                    }
                    tmpList.add(tmpXFile);
                } // for i
            }
            return tmpList;
        } catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
        return tmpList;
    }

    protected File getCridDirectory() {
        return aCridDirectory;
    }

    protected void setCridDirectory(File inpCridDirectory) {
        aCridDirectory = inpCridDirectory;
    }

    public File[] getFmpgDirectories() {
        return aFmpgDirectories;
    }

    protected void setFmpgDirectory(int inpIndex, File inpFmpgDirectory) {
        if (aFmpgDirectories != null && inpIndex >= 0
                && inpIndex < aFmpgDirectories.length) {
            aFmpgDirectories[inpIndex] = inpFmpgDirectory;
        }
    }

} // Ende von class GAufnahmeLocal
